<?php

/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package ShadePro
 */

/**
 * WooCommerce setup function.
 *
 * @link https://docs.woocommerce.com/document/third-party-custom-theme-compatibility/
 * @link https://github.com/woocommerce/woocommerce/wiki/Enabling-product-gallery-features-(zoom,-swipe,-lightbox)
 * @link https://github.com/woocommerce/woocommerce/wiki/Declaring-WooCommerce-support-in-themes
 *
 * @return void
 */
function shadepro_wc_setup()
{
	add_theme_support(
		'woocommerce',
		array(
			'thumbnail_image_width' => 255,
			'single_image_width'    => 492,
			'product_grid'          => array(
				'default_rows'    => 3,
				'min_rows'        => 1,
				'default_columns' => 3,
				'min_columns'     => 1,
				'max_columns'     => 6,
			),
		)
	);
	// add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support('wc-product-gallery-lightbox');
	add_theme_support('wc-product-gallery-slider');
}
add_action('after_setup_theme', 'shadepro_wc_setup');


function shadepro_default_catalog_orderby($sort_by)
{
	return 'date';
}
add_filter('woocommerce_default_catalog_orderby', 'shadepro_default_catalog_orderby');


/**
 * Change number of products that are displayed per page (shop page)
 */

function shop_loop_shop_per_page($cols)
{
	// $cols contains the current number of products per page based on the value stored on Options –> Reading
	// Return the number of products you wanna show per page.
	$cols = 9;
	return $cols;
}
add_filter('loop_shop_per_page', 'shop_loop_shop_per_page', 20);
/**
 * WooCommerce specific scripts & stylesheets.
 *
 * @return void
 */
function shadepro_wc_scripts()
{
	wp_enqueue_style('shadepro-woocommerce-style', get_theme_file_uri( '/assets/css/shade-woocommerce.css'), array('shadepro-style'));
	wp_style_add_data( 'shadepro-woocommerce-style', 'rtl', 'replace' );
}
add_action('wp_enqueue_scripts', 'shadepro_wc_scripts', 20);

/**
 * Disable the default WooCommerce stylesheet.
 *
 * Removing the default WooCommerce stylesheet and enqueing your own will
 * protect you during WooCommerce core updates.
 *
 * @link https://docs.woocommerce.com/document/disable-the-default-stylesheet/
 */
// add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

/**
 * Add 'woocommerce-active' class to the body tag.
 *
 * @param  array $classes CSS classes applied to the body tag.
 * @return array $classes modified to include 'woocommerce-active' class.
 */
function shadepro_wc_active_body_class($classes)
{
	$classes[] = 'woocommerce-active';

	return $classes;
}
add_filter('body_class', 'shadepro_wc_active_body_class');

/**
 * Related Products Args.
 *
 * @param array $args related products args.
 * @return array $args related products args.
 */
function shadepro_wc_related_products_args($args)
{
	$defaults = array(
		'posts_per_page' => 4,
		'columns'        => 4,
	);

	$args = wp_parse_args($defaults, $args);

	return $args;
}
add_filter('woocommerce_output_related_products_args', 'shadepro_wc_related_products_args');

/**
 * Remove the breadcrumbs 
 */
function woo_remove_wc_breadcrumbs()
{
	remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
}
add_action('init', 'woo_remove_wc_breadcrumbs');

/**
 * Remove default WooCommerce title.
 */
add_filter('woocommerce_show_page_title', 'shadepro_hide_shop_page_title');

function shadepro_hide_shop_page_title($title)
{
	$title = false;
	return $title;
}
/**
 * Remove default WooCommerce wrapper.
 */
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

if (!function_exists('shadepro_wc_wrapper_before')) {
	/**
	 * Before Content.
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function shadepro_wc_wrapper_before()
	{
		if (!is_product()) {
			global $shadeproObj;
			printf($shadeproObj->shadepro_breadcrumb_bridge());
		}

		if (is_active_sidebar('shadepro_woocommerce_widgets')) {
			$column_class = 'col-lg-9 col-md-8 woo-has-sidebar';
		} else {
			$column_class = 'col-12';
		}
?>
<div class="shadepro-woocommerce-page">
	<div class="container">
		<div class="row justify-content-center">
			<?php if (is_product()) : ?>
				<div class="col-md-12">
				<?php else :  ?>
					<?php if (is_active_sidebar('shadepro_woocommerce_widgets')) : ?>
						<div class="col-lg-3 col-md-4">
							<?php dynamic_sidebar('shadepro_woocommerce_widgets'); ?>
						</div>
					<?php endif; ?>
					<div class="<?php echo esc_attr($column_class); ?> shade-shop-items-wrap">
					<?php endif; ?>
					<main id="primary" class="site-main">
					<?php
				}
			}
add_action('woocommerce_before_main_content', 'shadepro_wc_wrapper_before');

if (!function_exists('shadepro_wc_wrapper_after')) {
	/**
	 * After Content.
	 *
	 * Closes the wrapping divs.
	 *
	 * @return void
	 */
	function shadepro_wc_wrapper_after()
	{
		?>
		</main><!-- #main -->
		</div>
	</div>
</div>

<?php
	}
}
add_action('woocommerce_after_main_content', 'shadepro_wc_wrapper_after', 10);
/**
 * Removing the woocommerce sidebar.
 *
 */
function disable_woo_commerce_sidebar()
{
	remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
}
add_action('init', 'disable_woo_commerce_sidebar');


/**
 * Sample implementation of the WooCommerce Mini Cart.
 *
 * You can add the WooCommerce Mini Cart to header.php like so ...
 *

	*/

if (!function_exists('shadepro_wc_cart_link_fragment')) {
	/**
	 * Cart Fragments.
	 *
	 * Ensure cart contents update when products are added to the cart via AJAX.
	 *
	 * @param array $fragments Fragments to refresh via AJAX.
	 * @return array Fragments to refresh via AJAX.
	 */
	function shadepro_wc_cart_link_fragment($fragments)
	{
		ob_start();
		shadepro_wc_cart_link();
		$fragments['a.cart-contents'] = ob_get_clean();

		return $fragments;
	}
}
add_filter('woocommerce_add_to_cart_fragments', 'shadepro_wc_cart_link_fragment');

if (!function_exists('shadepro_wc_cart_link')) {
	/**
	 * Cart Link.
	 *
	 * Displayed a link to the cart including the number of items present and the cart total.
	 *
	 * @return void
	 */
	function shadepro_wc_cart_link()
	{
?>
<a class="cart-contents" href="<?php echo esc_url(wc_get_cart_url()); ?>" title="<?php esc_attr_e('View your shopping cart', 'shadepro'); ?>">
<?php
		$item_count_text = sprintf(
			/* translators: number of items in the mini cart. */
			_n('%d item', '%d items', WC()->cart->get_cart_contents_count(), 'shadepro'),
			WC()->cart->get_cart_contents_count()
		);
?>
<span class="amount"><?php echo wp_kses_data(WC()->cart->get_cart_subtotal()); ?></span> <span class="count"><?php echo esc_html($item_count_text); ?></span>
</a>
<?php
	}
}

if (!function_exists('shadepro_wc_header_cart')) {
	/**
	 * Display Header Cart.
	 *
	 * @return void
	 */
	function shadepro_wc_header_cart()
	{
		if (is_cart()) {
			$class = 'current-menu-item';
		} else {
			$class = '';
		}
?>
<ul id="site-header-cart" class="site-header-cart">
<li class="<?php echo esc_attr($class); ?>">
	<?php shadepro_wc_cart_link(); ?>
</li>
<li>
	<?php
		$instance = array(
			'title' => '',
		);

		the_widget('WC_Widget_Cart', $instance);
	?>
</li>
</ul>
<?php
	}
}



/**
 * Remove categoryies.
 */
// remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );


/**
 * Adding price prefix.
 */
function shadepro_rrp_sale_price_html($price, $product)
{
	if ($product->is_on_sale()) :
		$has_sale_text = array(
			'<del aria-hidden="true">' => '<del><span class="price-prefix">' . esc_html__('List Price:', 'shadepro') . '</span> ',
			'<ins>' => '<br/> <ins> <span class="price-prefix">' . esc_html__('Price:', 'shadepro') . '</span> '
		);
		$return_string = str_replace(array_keys($has_sale_text), array_values($has_sale_text), $price);
	else :
		$return_string = '<span class="price-prefix">' . esc_html__('Price:', 'shadepro') . '</span>' . $price;
	endif;
	return $return_string;
}
add_filter('woocommerce_get_price_html', 'shadepro_rrp_sale_price_html', 100, 2);


add_action('woocommerce_before_add_to_cart_quantity', 'shadepro_before_qty_add');
function shadepro_before_qty_add()
{
	echo '<div class="qty-label">' . esc_html__('Quantity:', 'shadepro') . ' </div>';
}




// Change the product description title
add_filter('woocommerce_product_description_heading', 'shade_change_product_description_heading');
function shade_change_product_description_heading()
{
	return '';
}

// Change the additional information title tab

if (!function_exists('misha_rename_additional_info_tab')) {
	function misha_rename_additional_info_tab($tabs)
	{

		$tabs['additional_information']['title'] = esc_html__('Specification', 'shadepro');

		return $tabs;
	}
}
add_filter('woocommerce_product_tabs', 'misha_rename_additional_info_tab');


// wrapping up woo related products 
function move_related_products_before_tabs()
{
	remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
	// add_action( 'woocommerce_after_main_content', 'woocommerce_output_related_products' );
}
add_action('init', 'move_related_products_before_tabs');

if (!function_exists('shadepro_wc_related_product_wrapper_before')) {
	/**
	 * related product wrapping
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function shadepro_wc_related_product_wrapper_before()
	{
		global $product;
	
		if($product){
			
			$related_count = count(wc_get_related_products($product->get_id()));
		}else{
			$related_count = 0;
		}

		if (is_product() && 0 != $related_count) {
?>
<div class="shadepro-woo-related-product-area">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<?php
				woocommerce_output_related_products();
				?>
			</div>
		</div>
	</div>
</div>
<?php
		}
	}
}
add_action('woocommerce_after_main_content', 'shadepro_wc_related_product_wrapper_before', 40);


if (!function_exists('shadepro_wc_checkout_order_details_wrapper_start')) {
	/**
	 * related product wrapping
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function shadepro_wc_checkout_order_details_wrapper_start()
	{

?>
<div class="shadepro-wc-order-details-wrapp">

<?php

	}
}
add_action('woocommerce_checkout_after_customer_details', 'shadepro_wc_checkout_order_details_wrapper_start', 40);

if (!function_exists('shadepro_wc_checkout_order_details_wrapper_end')) {
	/**
	 * related product wrapping
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function shadepro_wc_checkout_order_details_wrapper_end()
	{

?>
</div>

<?php

	}
}
add_action('woocommerce_review_order_before_payment', 'shadepro_wc_checkout_order_details_wrapper_end');




/**
 * Woo Paginations..
 * @since 1.0.0
 */
add_filter('woocommerce_pagination_args', 	'shadepro_woo_pagination');
function shadepro_woo_pagination($args)
{

	$args['prev_text'] = '<i class="fa fa-angle-'.(is_rtl() ? 'right' : 'left').'"></i>';
	$args['next_text'] = '<i class="fa fa-angle-'.(is_rtl() ? 'left' : 'right').'"></i>';

	return $args;
}



add_filter('woocommerce_default_address_fields', 'shadepro_override_address_fields');
function shadepro_override_address_fields($address_fields)
{
	$address_fields['first_name']['placeholder'] = __('Enter your first name', 'shadepro');
	$address_fields['last_name']['placeholder'] = __('Enter your last name', 'shadepro');
	$address_fields['address_1']['placeholder'] = __('Enter your address', 'shadepro');
	$address_fields['state']['placeholder'] = __('Enter your state', 'shadepro');
	$address_fields['postcode']['placeholder'] = __('Enter your postcode', 'shadepro');
	$address_fields['city']['placeholder'] = __('Enter your city', 'shadepro');
	$address_fields['phone']['placeholder'] = __('Enter your phone', 'shadepro');
	$address_fields['email']['placeholder'] = __('Enter your email', 'shadepro');
	return $address_fields;
}



add_filter('shadepro_page_title', 'woo_title_order_received', 10, 2);

function woo_title_order_received($title)
{
	if (function_exists('is_order_received_page') && is_order_received_page()) {
		$title = '<div class="shade-order-success-icon"><img src="' . get_theme_file_uri( '/assets/img/order-success.png').'" alt="' . esc_attr__('order success', 'shadepro') . '" /></div>';
		$title .= "Order Successful";
		return  $title;
	}
	return $title;
}


// Add the code below to your theme's functions.php file to add a confirm password field on the register form under My Accounts.
add_filter('woocommerce_registration_errors', 'registration_errors_validation', 10, 3);
function registration_errors_validation($reg_errors, $sanitized_user_login, $user_email)
{
	global $woocommerce;
	extract($_POST);

	if (! isset($_POST['terms']) && wc_get_page_id( 'terms' ) > 0) {
		return new WP_Error('registration-error', __('Terms and condition are not checked!', 'shadepro'));
	}

	return $reg_errors;
}

add_action('woocommerce_register_form', 'wc_register_form_password_repeat');
function wc_register_form_password_repeat()
{

	if (wc_get_page_id( 'terms' ) > 0 ) {
?>
<p class="form-row terms wc-terms-and-conditions">
<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
	<input type="checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" name="terms" <?php checked(apply_filters('woocommerce_terms_is_checked_default', isset($_POST['terms'])), true); ?> id="terms" /> <span><?php printf(__('I agree to the <a href="%s" target="_blank" class="woocommerce-terms-and-conditions-link">Terms & conditions</a>', 'shadepro'), esc_url(wc_get_page_permalink('terms'))); ?></span>
</label>
<input type="hidden" name="terms-field" value="1" />
</p>
<?php
	}

}






/**
 * Shop/archives: wrap the product image/thumbnail in a div.
 * 
 * The product image itself is hooked in at priority 10 using woocommerce_template_loop_product_thumbnail(),
 * so priority 9 and 11 are used to open and close the div.
 */
add_action('woocommerce_before_shop_loop_item_title', function () {
	echo '<div class="product-thumb-wrapper">';
}, 9);
add_action('woocommerce_before_shop_loop_item_title', function () {
	echo '</div>';
}, 11);
