<?php

/**
 * Enqueue scripts and styles.
 */
function shadepro_scripts()
{
	if(is_rtl()){
		$redux = get_option('shadepro');
		$primary_font = isset($redux['body_typography']['font-family']) && $redux['body_typography']['font-family'] != '' ? str_replace(' ','-',strtolower($redux['body_typography']['font-family'])) : 'iran-yekan';
		$secondary_font = isset($redux['heading_typography']['font-family']) && $redux['heading_typography']['font-family'] != '' ? str_replace(' ','-',strtolower($redux['heading_typography']['font-family'])) : 'pinar';

		wp_enqueue_style('primary-font', get_theme_file_uri( '/assets/css/farsi-fonts-styles/primary-'.$primary_font.'.css'), array(), null);
		wp_enqueue_style('secondary-font', get_theme_file_uri( '/assets/css/farsi-fonts-styles/secondary-'.$secondary_font.'.css'), array(), null);
	}
	else{
		wp_enqueue_style('circular-std', get_theme_file_uri( '/assets/css/font-circular-std.css'), array(), null);
	}
	wp_enqueue_style('Font-awesome', get_theme_file_uri( '/assets/css/all.min.css'), array(), '4.7.0');

	wp_enqueue_style('bootstrap', get_theme_file_uri( '/assets/css/bootstrap.min.css'), array(), '4.0');
	wp_style_add_data( 'bootstrap', 'rtl', 'replace' );

	wp_enqueue_style('nice-select', get_theme_file_uri( '/assets/css/nice-select.min.css'), array(), 'null');
	wp_style_add_data( 'nice-select', 'rtl', 'replace' );

	wp_enqueue_style('meanmenu', get_theme_file_uri( '/assets/css/meanmenu.min.css'), array(), null);
	wp_enqueue_style('select2', get_theme_file_uri( '/assets/css/select2.min.css'), array(), null);
	
	wp_enqueue_style('shadepro-core', get_theme_file_uri( '/assets/css/core.css'), array(), SHADE_THEME_VERSION);
	wp_style_add_data( 'shadepro-core', 'rtl', 'replace' );

	wp_enqueue_style('shadepro-gutenberg', get_theme_file_uri( '/assets/css/gutenberg.css'), array(), SHADE_THEME_VERSION);
	wp_style_add_data( 'shadepro-gutenberg', 'rtl', 'replace' );

	wp_enqueue_style('shadepro-custom', get_theme_file_uri( '/assets/css/shadepro-style.css'), array(), SHADE_THEME_VERSION);
	wp_style_add_data( 'shadepro-custom', 'rtl', 'replace' );

	wp_enqueue_style('shadepro-style', get_stylesheet_uri(), array(), SHADE_THEME_VERSION);

	wp_enqueue_style('shadepro-responsive', get_theme_file_uri( '/assets/css/shadepro-responsive.css'), array(), SHADE_THEME_VERSION);
	wp_style_add_data( 'shadepro-responsive', 'rtl', 'replace' );

	if(is_rtl()){
		wp_enqueue_style('shadepro-rtl', get_theme_file_uri( '/assets/css/rtl.css'), array(), SHADE_THEME_VERSION);
	}

	wp_enqueue_script('masonry', get_theme_file_uri( '/assets/js/masonry.pkgd.min.js'), array('jquery'), null, true);
	wp_enqueue_script('nice-select', get_theme_file_uri( '/assets/js/jquery.nice-select.min.js'), array('jquery'), null, true);
	wp_enqueue_script('meanmenu-js', get_theme_file_uri( '/assets/js/jquery.meanmenu.min.js'), array('jquery'), null, true);
	wp_enqueue_script('select2', get_theme_file_uri( '/assets/js/select2.min.js'), array('jquery'), null, true);
	
	wp_enqueue_script('shadepro-main', get_theme_file_uri( '/assets/js/shadepro-main.js'), array('jquery'), SHADE_THEME_VERSION, true);
	wp_add_inline_script( 'shadepro-main', 'var $translations = ' . json_encode( [
		'more_comments' => esc_html__('More Comments', 'shadepro'),
		'loading' => esc_html__('Loading ...', 'shadepro'),
	] ), 'before' );

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'shadepro_scripts');


/**
 * Registers an editor stylesheet for the theme.
 */
function shadepro_theme_add_editor_styles()
{

	add_editor_style(get_theme_file_uri( '/assets/css/font-circular-std.css'));
	add_editor_style(get_theme_file_uri( '/assets/css/editor-style.css'));
}
add_action('admin_init', 'shadepro_theme_add_editor_styles');


/**
 * Registers an admin stylesheet for the theme.
 */
function shadepro_theme_add_admin_styles()
{
	if( is_rtl() ){
		$redux = get_option('shadepro');
		$primary_font = isset($redux['body_typography']['font-family']) && $redux['body_typography']['font-family'] != '' ? str_replace(' ','-',strtolower($redux['body_typography']['font-family'])) : 'iran-yekan';
		$secondary_font = isset($redux['heading_typography']['font-family']) && $redux['heading_typography']['font-family'] != '' ? str_replace(' ','-',strtolower($redux['heading_typography']['font-family'])) : 'pinar';

		wp_enqueue_style('primary-font', get_theme_file_uri( '/assets/css/farsi-fonts-styles/primary-'.$primary_font.'.css'), array(), null);
		wp_enqueue_style('secondary-font', get_theme_file_uri( '/assets/css/farsi-fonts-styles/secondary-'.$secondary_font.'.css'), array(), null);
		wp_enqueue_style('admin-font', get_theme_file_uri( '/assets/css/farsi-fonts-styles/admin-iran-yekan.css'), array(), null);
		wp_enqueue_style('admin-style', get_theme_file_uri( '/assets/css/admin.css'), array(), null);
	}
}
add_action('admin_enqueue_scripts', 'shadepro_theme_add_admin_styles');
add_action('login_enqueue_scripts', 'shadepro_theme_add_admin_styles');
if ( did_action( 'elementor/loaded' ) ) {
	add_action('elementor/editor/before_enqueue_scripts', 'shadepro_theme_add_admin_styles');
}
