<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}



/* Theme demo data setup */
function shadepro_import_files()
{
    return array(
        array(
            'import_file_name' => __('Initial Setup', 'shadepro'),
            'categories' => array('Inner Pages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/initial-setup.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/screenshot.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/',
        ),
        array(
            'import_file_name' => __('Project Management', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/project-management.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/project-management.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/project-management',
        ),
        array(
            'import_file_name' => __('Financial Tracker', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/financial-tracker.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/financial-tracker.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/financial-tracker',
        ),
        array(
            'import_file_name' => __('Email Marketing', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/email-marketing.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/email-marketing.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/email-marketing',
        ),
        array(
            'import_file_name' => __('Task Management', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/task-management.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/task-management.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/task-management',
        ),
        array(
            'import_file_name' => __('Digital Marketing', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/digital-marketing.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/digital-marketing.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/digital-marketing',
        ),
        array(
            'import_file_name' => __('Event', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/event.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/event.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/event',
        ),
        array(
            'import_file_name' => __('Online Education', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/online-education.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/online-education.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/education',
        ),
        array(
            'import_file_name' => __('eBook', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/ebook.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/ebook.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/ebook',
        ),
        array(
            'import_file_name' => __('Desktop Software', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/desktop-software.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/desktop-software.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/desktop-software',
        ),
        array(
            'import_file_name' => __('Team Management', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/team-management.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/team-management.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/team-management',
        ),
        array(
            'import_file_name' => __('SasS Service', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/sass-service.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/sass-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/sass-service',
        ),
        array(
            'import_file_name' => __('Social App', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/social-app.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/social-app.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/social-app',
        ),
        array(
            'import_file_name' => __('Mobile App 3.0', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/mobile-app-3.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/mobile-app-3.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/mobile-app-3',
        ),
        array(
            'import_file_name' => __('Software', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/software.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/software.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/software',
        ),
        array(
            'import_file_name' => __('Chat Service', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/chat-service.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/sass-application.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/chat-service',
        ),
        array(
            'import_file_name' => __('IOS App', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/ios-app.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/app.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/app',
        ),
        array(
            'import_file_name' => __('Agency', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/agency.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/agency.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/agency',
        ),
        array(
            'import_file_name' => __('ECommerce', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/ecommerce.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/ecommerce.jpg',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/ecommerce',
        ),
        array(
            'import_file_name' => __('Sass Subscription', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/sass.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/sass.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/sass-subscription',
        ),
        array(
            'import_file_name' => __('Video Conference', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/video-conference.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/video.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/video-conference',
        ),
        array(
            'import_file_name' => __('Web Application', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/web.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/web.jpg',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/web-application',
        ),
        array(
            'import_file_name' => __('Job Site', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/job-site.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/job-site.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/job-site',
        ),
        array(
            'import_file_name' => __('Mobile App', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/mobile-app.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/mobile-app.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/mobile-app',
        ),
        array(
            'import_file_name' => __('Product Landing', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/product-landing.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/product-landing.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/product-landing',
        ),
        array(
            'import_file_name' => __('Telemedicine', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/telemedicine.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/telemedicine.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/telemedicine',
        ),
        array(
            'import_file_name' => __('B2B', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/b2b.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/b2b.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/b2b',
        ),
        array(
            'import_file_name' => __('Consultation', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/consultation.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/consultation.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/consultation',
        ),
        array(
            'import_file_name' => __('Coworking', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/coworking.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/coworking.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/coworking',
        ),
        array(
            'import_file_name' => __('Digital Service', 'shadepro'),
            'categories' => array('Homepages'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/digital-service.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/digital-service.png',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/digital-service',
        ),
        array(
            'import_file_name' => __('Portfolio Collection', 'shadepro'),
            'categories' => array('Portfolio'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/portfolio.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/portfolio.jpg',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/portfolio',
        ),
        array(
            'import_file_name' => __('Elements', 'shadepro'),
            'categories' => array('Elements'),
            'local_import_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/elements.xml',
            'local_import_widget_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/widget.wie',
            'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'inc/demo-contents/customizer.dat',
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit(get_template_directory()) . 'inc/demo-contents/theme-options.json',
                    'option_name' => 'shadepro',
                ),
            ),
            'import_preview_image_url' => home_url() . '/wp-content/themes/shadepro/inc/demo-contents/previews/elements.jpg',
            'import_notice' => __('After you import this demo, you will have to setup the nav menu.', 'shadepro'),
            'preview_url' => 'https://v3dboy.ir/previews/wordpress/shadepro/',
        ),
    );
}
add_filter('pt-ocdi/import_files', 'shadepro_import_files');


function ocdi_after_import($selected_import)
{    

    $front_page_id = get_page_by_title('Agency');

    if ( __('SasS Service', 'shadepro') === $selected_import['import_file_name'] ){
        // Assign front page and posts page (blog page).
        $front_page_id = get_page_by_title('خدمات Saas');
    }elseif (__('Social App', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اپلیکیشن اجتماعی');
    }elseif (__('eBook', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('کتاب الکترونیکی');
    }elseif (__('Desktop Software', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('نرم افزار دسکتاپ');
    }elseif (__('Team Management', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('مدیریت تیم');
    }elseif (__('Mobile App 3.0', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اپلیکیشن موبایل 3.0');
    }elseif (__('Software', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('نرم افزار');
    }elseif (__('ECommerce', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('تجارت الکترونیک');
    } elseif (__('Agency', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('نمایندگی');
    } elseif (__('Sass Subscription', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اشتراک Saas');
    } elseif (__('Video Conference', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('ویدئو کنفرانس');
    } elseif (__('Web Application', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اپلیکیشن وب');
    }elseif (__('Coworking', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('همکاری');
    }elseif (__('Consultation', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('مشاوره');
    }elseif (__('B2B', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('کسب و کار');
    }elseif (__('Job Site', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('فهرست مشاغل');
    }elseif (__('Mobile App', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اپلیکیشن موبایل');
    }elseif (__('Product Landing', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('معرفی محصول');
    }elseif (__('IOS App', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('اپلیکیشن IOS');
    }elseif (__('Chat Service', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('خدمات گفتگو');
    }
    elseif (__('Telemedicine', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('پزشکی از راه دور');
    }
    elseif (__('Online Education', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('آموزش آنلاین');
    }
    elseif (__('Event', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('رویداد');
    }
    elseif (__('Digital Marketing', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('بازاریابی دیجیتال');
    }
    elseif (__('Email Marketing', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('بازاریابی ایمیل');
    }
    elseif (__('Task Management', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('مدیریت وظیفه');
    }
    elseif (__('Financial Tracker', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('ردیاب مالی');
    }
    elseif (__('Project Management', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('مدیریت پروژه');
    }
    elseif (__('Digital Service', 'shadepro') === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_title('خدمات دیجیتال');
    }
    else{
        $front_page_id = get_page_by_title('بازاریابی ایمیل');
    }

    $main_menu = get_term_by('name', 'منوی اصلی', 'nav_menu');
    set_theme_mod('nav_menu_locations', array(
        'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function
    ));
    $blog_page_id  = get_page_by_title('بلاگ');
    update_option('show_on_front', 'page');
    update_option('page_on_front', $front_page_id->ID);
    update_option('page_for_posts', $blog_page_id->ID);

    update_option('elementor_scheme_color', array('#161c2d', '#161c2d', '#6E727D', '#473bf0'));
    $elem_clear_cache = new\Elementor\Core\Files\Manager();
    $elem_clear_cache->clear_cache();
}
add_action('pt-ocdi/after_import', 'ocdi_after_import');
