<?php
// File Security Check
if (!defined('ABSPATH')) {
	exit;
}
function shadepro_theme_options_style()
{
	// Globalizing theme options values
	$shadepro = get_option('shadepro');
	//
	// Enqueueing StyleSheet file
	//
	wp_enqueue_style('shadepro-theme-options-style', get_theme_file_uri( '/assets/css/theme_options_style.css'), ['shadepro-responsive'] );
	$page_id = get_the_ID();
	$css_output = '';
	/*=============================================
	=            CUSTOM BACKGROUND STYLE          =
	=============================================*/

	if (isset($shadepro['logo_max_width_desktop'])) {
		$css_output .= "
			.site-branding,.site-logo{
				max-width: {$shadepro['logo_max_width_desktop']}px;
			}
		";
	}
	if (isset($shadepro['logo_max_width_mobile'])) {
		$css_output .= "
			@media (max-width: 680px){
				.site-branding, .site-logo{
					max-width: {$shadepro['logo_max_width_mobile']}px;
				}
			}
		";
	}

	if (isset($shadepro['scustom_css'])) {
		$css_output .= $shadepro['scustom_css'];
	}

	// theme color set 
	if (isset($shadepro['custom_accent_color']) || isset($shadepro['heading_color']) || isset($shadepro['text_color'])) {

		$css_output .= "
		:root {
			--accent-color: {$shadepro['custom_accent_color']};
			--heading-color: {$shadepro['heading_color']};
			--text-color: {$shadepro['text_color']};
		}
		";

		$accent_color = $shadepro['custom_accent_color'];
		$heading_color = $shadepro['heading_color'];
		$text_color = $shadepro['text_color'];
		update_option( 'elementor_scheme_color', array($heading_color, $heading_color, $text_color, $accent_color) );

	
	}

	//
	// Header Buttons Color
	//
	$body_background_color = get_post_meta(get_the_ID(), 'body_background_color', true);
	$btns_bg_color = get_post_meta(get_the_ID(), 'buttons_background_color', true);
	$btns_text_color = get_post_meta(get_the_ID(), 'buttons_text_color', true);
	$buttons_border_color = get_post_meta(get_the_ID(), 'buttons_border_color', true);
	$buttons_hover_background_color = get_post_meta(get_the_ID(), 'buttons_hover_background_color', true);
	$buttons_hover_text_color = get_post_meta(get_the_ID(), 'buttons_hover_text_color', true);
	$buttons_hover_border_color = get_post_meta(get_the_ID(), 'buttons_hover_border_color', true);
	$btn2_btns_bg_color = get_post_meta(get_the_ID(), 'btn2_buttons_background_color', true);
	$btn2_btns_text_color = get_post_meta(get_the_ID(), 'btn2_buttons_text_color', true);
	$btn2_buttons_hover_background_color = get_post_meta(get_the_ID(), 'btn2_buttons_hover_background_color', true);
	$btn2_buttons_hover_text_color = get_post_meta(get_the_ID(), 'btn2_buttons_hover_text_color', true);
	$btn2_buttons_hover_border_color = get_post_meta(get_the_ID(), 'btn2_buttons_hover_border_color', true);
	$button_1_custom_css = get_post_meta(get_the_ID(), 'button_1_custom_css', true);
	$button_2_custom_css = get_post_meta(get_the_ID(), 'button_2_custom_css', true);
	if ($body_background_color) {
		$css_output .= "
			body.page-id-{$page_id} {
				background-color: {$body_background_color};
			}
		";
	}
	if ($btns_bg_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn{
				background: {$btns_bg_color};
			}
		";
	}
	if ($buttons_border_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn{
				border-color: {$buttons_border_color} !important;
			}
		";
	}
	if ($btns_text_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn{
				color: {$btns_text_color} !important;
			}
		";
	}
	if ($buttons_hover_background_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:hover, .shadepro-header-area a.shadepro-login-btn:last-child{
				background: {$buttons_hover_background_color};
			}
		";
	}
	if ($buttons_hover_text_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:hover, .shadepro-header-area a.shadepro-login-btn:last-child{
				color: {$buttons_hover_text_color} !important;
			}
		";
	}
	if ($buttons_hover_border_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:hover, .shadepro-header-area a.shadepro-login-btn:last-child{
				border-color: {$buttons_hover_border_color};
			}
		";
	}
	//
	// Header Buttons Color on btn2 mode
	//
	if ($btn2_btns_bg_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:nth-child(2){
				background: {$btn2_btns_bg_color};
			}
		";
	}
	if ($btn2_btns_text_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:nth-child(2){
				color: {$btn2_btns_text_color} !important;
			}
		";
	}
	if ($btn2_buttons_hover_background_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:nth-child(2):hover, .shadepro-header-area a.shadepro-login-btn:nth-child(2):last-child{
				background: {$btn2_buttons_hover_background_color};
			}
		";
	}
	if ($btn2_buttons_hover_text_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:nth-child(2):hover, .shadepro-header-area a.shadepro-login-btn:nth-child(2):last-child{
				color: {$btn2_buttons_hover_text_color} !important;
			}
		";
	}
	if ($btn2_buttons_hover_border_color) {
		$css_output .= "
			body.page-id-{$page_id} .shadepro-header-area a.shadepro-login-btn:nth-child(2):hover, .shadepro-header-area a.shadepro-login-btn:nth-child(2):last-child{
				border-color: {$btn2_buttons_hover_border_color} !important;
			}
		";
	}

	// Header buttons custom css
	if($button_1_custom_css){
		$css_output .= "
		.shadepro-header-area a.shadepro-login-btn:nth-child(1){
				{$button_1_custom_css}
			}
		";
	}
	if($button_2_custom_css){
		$css_output .= "
		.shadepro-header-area a.shadepro-login-btn:nth-child(2){
				{$button_2_custom_css}
			}
		";
	}

	$css_output .= '
	.shade-wc-widget .price_slider_wrapper .price_slider_amount:before {
		content: "'.esc_html__( 'to', 'shadepro' ).'";
	}
	.shade-wc-widget .price_slider_wrapper .price_slider_amount button.button:after {
		content: "'.esc_html__( 'go', 'shadepro' ).'";
	}
	.woocommerce div.product div.images .woocommerce-product-gallery__wrapper a:after {
		content: "'.esc_html__( 'Sale!', 'shadepro' ).'";
	}
	.main-navigation .badge-new > a::after {
		content: "'.esc_html__( 'New', 'shadepro' ).'";
        background-color: #f34d4d;
        color: #fff;
        font-weight: 400;
        text-transform: uppercase;
        margin-'.(is_rtl() ? 'right' : 'left').': 10px;
		display: inline-block;
		padding: 2px 5px 4px;
		font-size: 75%;
		line-height: 1;
		text-align: center;
		white-space: nowrap;
		vertical-align: middle;
		margin-top: 2px;
		border-radius: 0.25rem;
    }
	';

	wp_add_inline_style('shadepro-theme-options-style', $css_output);

}
add_action('get_footer', 'shadepro_theme_options_style');

