<?php

if( function_exists('acf_add_local_field_group') ):


    
    acf_add_local_field_group(array(
        'key' => 'group_5b5ab6357a14d',
        'title' => __('Page Options', 'shadepro'),
        'fields' => array(
            array(
                'key' => 'field_5b5db8adfad44',
                'label' => __('General', 'shadepro'),
                'name' => '',
                'type' => 'tab',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'placement' => 'left',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_5c721ec24addf',
                'label' => __('Body Background Color', 'shadepro'),
                'name' => 'body_background_color',
                'type' => 'color_picker',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
            ),           
    
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'page',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
    
    acf_add_local_field_group(array(
        'key' => 'group_5b82b1e19608e',
        'title' => __('Post Page Layout', 'shadepro'),
        'fields' => array(
            array(
                'key' => 'field_5b82b1e86dd24',
                'label' => __('Use Custom Page Layout?', 'shadepro'),
                'name' => 'use_custom_page_layout',
                'type' => 'true_false',
                'instructions' => __('Check this to override theme default single page layout function to any custom layout for this page only.', 'shadepro'),
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'message' => __('Yes', 'shadepro'),
                'default_value' => 0,
                'ui' => 0,
                'ui_on_text' => '',
                'ui_off_text' => '',
            ),
            array(
                'key' => 'field_5b82b1fd6dd25',
                'label' => __('Select Custom Layout', 'shadepro'),
                'name' => 'select_custom_layout',
                'type' => 'select',
                'instructions' => __('Select custom page layout for this posts page.', 'shadepro'),
                'required' => 0,
                'conditional_logic' => array(
                    array(
                        array(
                            'field' => 'field_5b82b1e86dd24',
                            'operator' => '==',
                            'value' => '1',
                        ),
                    ),
                ),
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'choices' => array(
                    'fullpage' => __('Full Page', 'shadepro'),
                    'left-sidebar' => (is_rtl() ? __('Right Sidebar', 'shadepro') : __('Left Sidebar', 'shadepro')),
                    'right-sidebar' => (is_rtl() ? __('Left Sidebar', 'shadepro') : __('Right Sidebar', 'shadepro')),
                ),
                'default_value' => false,
                'allow_null' => 0,
                'multiple' => 0,
                'ui' => 0,
                'return_format' => 'value',
                'ajax' => 0,
                'placeholder' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'post',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'side',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
        'modified' => false,
    ));

    acf_add_local_field_group(array(
        'key' => 'group_5f6ec796e796e',
        'title' => __('Job Meta', 'shadepro'),
        'fields' => array(
            array(
                'key' => 'field_5f6ec9dd8a07c',
                'label' => __('Options', 'shadepro'),
                'name' => '',
                'type' => 'accordion',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'open' => 0,
                'multi_expand' => 0,
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_5f732a77f7a1f',
                'label' => __('Company Name', 'shadepro'),
                'name' => 'company_name',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => __('Dorfus', 'shadepro'),
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5f6eca028a07d',
                'label' => __('Company Logo', 'shadepro'),
                'name' => 'company_logo',
                'type' => 'image',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'return_format' => 'id',
                'preview_size' => 'medium',
                'library' => 'all',
                'min_width' => '',
                'min_height' => '',
                'min_size' => '',
                'max_width' => '',
                'max_height' => '',
                'max_size' => '',
                'mime_types' => '',
            ),
            array(
                'key' => 'field_5f6eca218a07e',
                'label' => __('Apply Button Label', 'shadepro'),
                'name' => 'apply_button_label',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => __('Apply for this job', 'shadepro'),
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5f6eca3b8a07f',
                'label' => __('Apply Button URL', 'shadepro'),
                'name' => 'apply_button_url',
                'type' => 'url',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '#',
                'placeholder' => '',
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'job',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));
    
    acf_add_local_field_group(array(
        'key' => 'group_5f69fd565b256',
        'title' => __('Team Meta', 'shadepro'),
        'fields' => array(
            array(
                'key' => 'field_5f69fd73be1bc',
                'label' => __('General', 'shadepro'),
                'name' => '',
                'type' => 'tab',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'placement' => 'left',
                'endpoint' => 0,
            ),
            array(
                'key' => 'field_5f69fd83be1bd',
                'label' => __('Position', 'shadepro'),
                'name' => 'position',
                'type' => 'text',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'default_value' => '',
                'placeholder' => __('Founder', 'shadepro'),
                'prepend' => '',
                'append' => '',
                'maxlength' => '',
            ),
            array(
                'key' => 'field_5f69fdfe6c023',
                'label' => __('Social Links', 'shadepro'),
                'name' => 'social_links',
                'type' => 'repeater',
                'instructions' => '',
                'required' => 0,
                'conditional_logic' => 0,
                'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                ),
                'collapsed' => '',
                'min' => 0,
                'max' => 0,
                'layout' => 'table',
                'button_label' => '',
                'sub_fields' => array(
                    array(
                        'key' => 'field_5f69fe0f6c024',
                        'label' => __('icon', 'shadepro'),
                        'name' => 'icon',
                        'type' => 'font-awesome',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'icon_sets' => array(
                            0 => 'fas',
                            1 => 'far',
                            2 => 'fab',
                        ),
                        'custom_icon_set' => '',
                        'default_label' => '',
                        'default_value' => '',
                        'save_format' => 'element',
                        'allow_null' => 0,
                        'show_preview' => 1,
                        'enqueue_fa' => 0,
                        'fa_live_preview' => '',
                        'choices' => array(
                        ),
                    ),
                    array(
                        'key' => 'field_5f69feb807fcb',
                        'label' => __('URL', 'shadepro'),
                        'name' => 'url',
                        'type' => 'url',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => 'https://facebook.com',
                        'placeholder' => 'https://facebook.com',
                    ),
                ),
            ),
        ),
        'location' => array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'team',
                ),
            ),
        ),
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ));


//Portfolio start
acf_add_local_field_group(array(
    'key' => 'group_5f0a920bd543d',
    'title' => __('Portfolio Option', 'shadepro'),
    'fields' => array(
        /* array(
            'key' => 'field_5f0a929d6a3ad',
            'label' => __('Portfolio Type', 'shadepro'),
            'name' => 'portfolio_type',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'designer' => 'Designer',
                'designer-2' => 'Designer 2',
                'developer' => 'Developer',
                'agency' => 'Agency',
                'photography' => 'Photography',
                'photography-2' => 'Photography 2',
            ),
            'default_value' => 'Designer',
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ), */
        array(
            'key' => 'client_name',
            'label' => __('Client Name', 'shadepro'),
            'name' => 'client_name',
            'type' => 'text',
            'instructions' => '',
            'required' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'default_value' => __('Maveland Inc.', 'shadepro'),
            'placeholder' => '',
            'prepend' => '',
            'append' => '',
            'maxlength' => '',
        ),
        array(
            'key' => 'field_5f0a93936a3ae',
            'label' => __('Portfolio Grid', 'shadepro'),
            'name' => 'image_width',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                4 => __('4 column', 'shadepro'),
                3 => __('3 column', 'shadepro'),
                6 => __('6 column', 'shadepro'),
                12 => __('Fulwidth', 'shadepro'),
            ),
            'default_value' => 3,
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
        array(
            'key' => 'field_5f0b0fc730f1b',
            'label' => __('Image Height', 'shadepro'),
            'name' => 'image_height',
            'type' => 'select',
            'instructions' => '',
            'required' => 0,
            'conditional_logic' => 0,
            'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
            ),
            'choices' => array(
                'normal' => __('Normal', 'shadepro'),
                'big' => __('Big', 'shadepro'),
            ),
            'default_value' => 'normal',
            'allow_null' => 0,
            'multiple' => 0,
            'ui' => 0,
            'return_format' => 'value',
            'ajax' => 0,
            'placeholder' => '',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'portfolio',
            ),
        ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => '',
));
//end portfolio meta

//Main Menu
acf_add_local_field_group(array(
	'key' => 'group_5fe431f037a11',
	'title' => __('Menu Item Option', 'shadepro'),
	'fields' => array(
		array(
			'key' => 'field_5fe43201d9712',
			'label' => __('Hide this menu', 'shadepro'),
			'name' => 'hide_this_menu',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5fe43201',
			'label' => __('Mark as megamenu title', 'shadepro'),
			'name' => 'is_it_title',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'nav_menu_item',
				'operator' => '==',
				'value' => 'all',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));



acf_add_local_field_group(array(
	'key' => 'group_600e8b288c563',
	'title' => __('Header Footer Include/Exclude Permission', 'shadepro'),
	'fields' => array(
		array(
			'key' => 'field_600e8b3a91509',
			'label' => __('Include Rules', 'shadepro'),
			'name' => 'include_rules',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => __('Add Include Rule', 'shadepro'),
			'sub_fields' => array(
				array(
					'key' => 'field_600e8bd99150a',
					'label' => __('Include On', 'shadepro'),
					'name' => 'include_on',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'all' => __('Entire Website', 'shadepro'),
						'specific' => __('Specific Pages', 'shadepro'),
					),
					'default_value' => false,
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_600e8cc79150b',
					'label' => __('Pages', 'shadepro'),
					'name' => 'pages',
					'type' => 'post_object',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_600e8bd99150a',
								'operator' => '==',
								'value' => 'specific',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'post_type' => array(
                        0 => 'page',
                        1 => 'post',
					),
					'taxonomy' => '',
					'allow_null' => 0,
					'multiple' => 0,
					'return_format' => 'id',
					'ui' => 1,
                ),
                
			),
		),
		array(
			'key' => 'field_600e8d139150c',
			'label' => __('Exclude Rules', 'shadepro'),
			'name' => 'exclude_rules',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => __('Add Exclude Rule', 'shadepro'),
			'sub_fields' => array(
				array(
					'key' => 'field_600e8d139150d',
					'label' => __('Exclude On', 'shadepro'),
					'name' => 'exclude_on',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'all' => __('Entire Website', 'shadepro'),
						'specific' => __('Specific Pages', 'shadepro'),
					),
					'default_value' => false,
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
				array(
					'key' => 'field_600e8d139150e',
					'label' => __('Pages', 'shadepro'),
					'name' => 'pages',
					'type' => 'post_object',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_600e8d139150d',
								'operator' => '==',
								'value' => 'specific',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'post_type' => array(
						0 => 'page',
                        1 => 'post',
					),
					'taxonomy' => '',
					'allow_null' => 0,
					'multiple' => 0,
					'return_format' => 'id',
					'ui' => 1,
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'shadepro_header',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'shadepro_footer',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));



endif;